/*
 * Decompiled with CFR 0.152.
 */
package generic.jar;

import generic.jar.JarEntryFilter;
import generic.jar.JarEntryNode;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarEntryRootNode
extends JarEntryNode {
    private JarFile jarFile;
    private File file;

    public JarEntryRootNode(File file, JarEntryFilter filter) throws IOException {
        super(null, "");
        this.jarFile = new JarFile(file);
        this.file = file;
        if (filter == null) {
            filter = new DefaultFilter();
        }
        this.createIndex(filter);
    }

    @Override
    protected JarFile getJarFile() {
        return this.jarFile;
    }

    protected File getFile() {
        return this.file;
    }

    public URL toURL() throws MalformedURLException {
        return this.file.toURI().toURL();
    }

    private void createIndex(JarEntryFilter filter) {
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (jarEntry.isDirectory() || !filter.accepts(jarEntry)) continue;
            this.addFile(jarEntry.getName());
        }
    }

    private void addFile(String path) {
        String[] split = path.split("/");
        JarEntryNode node = this;
        for (String string : split) {
            node = this.getOrCreateNode(node, string);
        }
    }

    private JarEntryNode getOrCreateNode(JarEntryNode node, String name) {
        return node.createNode(name);
    }

    private static class DefaultFilter
    implements JarEntryFilter {
        private DefaultFilter() {
        }

        @Override
        public boolean accepts(JarEntry jarEntry) {
            String name = jarEntry.getName();
            if (name.endsWith(".class")) {
                return false;
            }
            if (name.endsWith(".png")) {
                return false;
            }
            return !name.endsWith(".gif");
        }
    }
}

