/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.util.image.ToolIconURL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import resources.ResourceManager;

class IconMap {
    private static Map<String, ToolIconURL> map = IconMap.createIconMap();

    IconMap() {
    }

    private static Map<String, ToolIconURL> createIconMap() {
        HashMap<String, ToolIconURL> iconMap = new HashMap<String, ToolIconURL>();
        IconMap.load(iconMap);
        return iconMap;
    }

    static void put(String name, ToolIconURL icon) {
        map.put(name, icon);
    }

    static ToolIconURL remove(String name) {
        return map.remove(name);
    }

    static ToolIconURL get(String name) {
        return map.get(name);
    }

    static List<String> getIconNames() {
        ArrayList<String> list = new ArrayList<String>(map.keySet());
        Collections.sort(list);
        return list;
    }

    static List<ToolIconURL> getIcons() {
        ArrayList<ToolIconURL> list = new ArrayList<ToolIconURL>(map.values());
        Collections.sort(list);
        return list;
    }

    private static void load(Map<String, ToolIconURL> iconMap) {
        Set images = ResourceManager.getToolImages();
        for (String filename : images) {
            int pos = filename.lastIndexOf(47);
            if (pos >= 0) {
                filename = filename.substring(pos + 1);
            }
            if (iconMap.containsKey(filename)) continue;
            iconMap.put(filename, new ToolIconURL(filename));
        }
    }
}

