/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AddressSetMapping {
    private AddressSetView set;
    private List<AddressRange> ranges;
    private int[] indexes;
    private AddressRange currentRange;
    private int currentRangeStart = -1;
    private int currentRangeEnd = -1;
    private int currentRangeIndex = -1;
    private final int maxIndex;

    public AddressSetMapping(AddressSetView set) {
        if (set == null) {
            throw new IllegalArgumentException("The address set can't be null");
        }
        if (set.getNumAddresses() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This class does not support AddressSets whose size >= 0x7fffffff byte addresses.");
        }
        this.set = set;
        this.ranges = this.getAddressRangesFromAddressSet();
        this.indexes = this.getStartIndexesForAllAddressRanges();
        this.maxIndex = (int)set.getNumAddresses();
    }

    public Address getAddress(int index) {
        if (index < 0 || index >= this.maxIndex) {
            return null;
        }
        if (!this.indexInCurrentRange(index)) {
            this.setCurrentRange(index);
        }
        return this.getAddress(this.currentRange, index - this.currentRangeStart);
    }

    private void setCurrentRange(int index) {
        if (index == this.currentRangeEnd + 1) {
            ++this.currentRangeIndex;
            this.currentRange = this.ranges.get(this.currentRangeIndex);
        } else {
            this.currentRangeIndex = Arrays.binarySearch(this.indexes, index);
            if (this.currentRangeIndex < 0) {
                this.currentRangeIndex = -this.currentRangeIndex - 2;
            }
        }
        this.currentRange = this.ranges.get(this.currentRangeIndex);
        this.currentRangeStart = this.indexes[this.currentRangeIndex];
        this.currentRangeEnd = this.currentRangeStart + (int)this.currentRange.getLength() - 1;
    }

    private boolean indexInCurrentRange(int index) {
        return index >= this.currentRangeStart && index <= this.currentRangeEnd;
    }

    private Address getAddress(AddressRange range, int offset) {
        return range.getMinAddress().add(offset);
    }

    private int[] getStartIndexesForAllAddressRanges() {
        int[] starts = new int[this.ranges.size() + 1];
        starts[0] = 0;
        int i = 1;
        for (AddressRange range : this.ranges) {
            starts[i] = starts[i - 1] + (int)range.getLength();
            ++i;
        }
        return starts;
    }

    private List<AddressRange> getAddressRangesFromAddressSet() {
        ArrayList<AddressRange> list = new ArrayList<AddressRange>();
        for (AddressRange addressRange : this.set) {
            list.add(addressRange);
        }
        return list;
    }
}

