/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph;

import ghidra.graph.GraphPath;
import java.util.HashSet;
import java.util.Set;

public class GraphPathSet<V> {
    private Set<GraphPath<V>> paths = new HashSet<GraphPath<V>>();

    public boolean containSomePathStartingWith(GraphPath<V> otherPath) {
        for (GraphPath<V> path : this.paths) {
            if (!path.startsWith(otherPath)) continue;
            return true;
        }
        return false;
    }

    public void add(GraphPath<V> path) {
        this.paths.add(path);
    }

    public Set<GraphPath<V>> getPathsContaining(V v) {
        HashSet<GraphPath<V>> set = new HashSet<GraphPath<V>>();
        for (GraphPath<V> path : this.paths) {
            if (!path.contains(v)) continue;
            set.add(path);
        }
        return set;
    }

    public int size() {
        return this.paths.size();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (GraphPath<V> path : this.paths) {
            buf.append(path.toString()).append('\n');
        }
        return buf.toString();
    }
}

