/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.iso9660;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ISO9660PathTable
implements StructConverter {
    private byte dirIdentifierLength;
    private byte extendedAttributeRecordLength;
    private int locationOfExtent;
    private short directoryNumberPathIndex;
    private byte[] directoryIdentifier;
    private byte paddingField;
    private boolean paddingFieldPresent;
    private long volumeIndex;
    private boolean littleEndian;

    public ISO9660PathTable(BinaryReader reader, boolean littleEndian) throws IOException {
        reader.setLittleEndian(littleEndian);
        this.littleEndian = littleEndian;
        this.volumeIndex = reader.getPointerIndex();
        this.dirIdentifierLength = reader.readNextByte();
        this.extendedAttributeRecordLength = reader.readNextByte();
        this.locationOfExtent = reader.readNextInt();
        this.directoryNumberPathIndex = reader.readNextShort();
        this.directoryIdentifier = reader.readNextByteArray((int)this.dirIdentifierLength);
        if (this.dirIdentifierLength % 2 != 0) {
            this.paddingField = reader.readNextByte();
            this.paddingFieldPresent = true;
        } else {
            this.paddingFieldPresent = false;
        }
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struc = this.littleEndian ? new StructureDataType("ISO9660TypeLPathTable", 0) : new StructureDataType("ISO9660TypeMPathTable", 0);
        struc.add(BYTE, "Directory Identifier Length", "Length of Directory Identifier");
        struc.add(BYTE, "Extended Attribute Record Length", "Length of Extended Attribute Record");
        struc.add(DWORD, "Location of Extent", "Location of Extent in Little-endian format");
        struc.add(WORD, "Directory Number", "Number of parent directory (an index in to the path table)");
        struc.add((DataType)new ArrayDataType(BYTE, this.directoryIdentifier.length, 1), "Directory Identifier", "Directory Identifier");
        if (this.paddingFieldPresent) {
            struc.add(BYTE, "Padding Field", "Padding Field");
        }
        return struc;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Directory Identifier Length: 0x" + Integer.toHexString(this.dirIdentifierLength) + "\n");
        buff.append("Extended Attribute Record Length: " + Integer.toHexString(this.extendedAttributeRecordLength) + "\n");
        buff.append("Location of Extent (LBA): 0x" + Integer.toHexString(this.locationOfExtent) + "\n");
        buff.append("Directory Number: 0x" + Integer.toHexString(this.directoryNumberPathIndex) + "\n");
        buff.append("Directory Identifier: " + new String(this.directoryIdentifier).trim() + "\n");
        if (this.paddingFieldPresent) {
            buff.append("PaddingF ield: 0x" + Integer.toHexString(this.paddingField) + "\n");
        }
        return buff.toString();
    }

    public byte getDirIdentifierLength() {
        return this.dirIdentifierLength;
    }

    public byte getExtendedAttributeRecordLength() {
        return this.extendedAttributeRecordLength;
    }

    public int getLocationOfExtent() {
        return this.locationOfExtent;
    }

    public short getDirectoryNumberPathIndex() {
        return this.directoryNumberPathIndex;
    }

    public byte[] getDirectoryIdentifier() {
        return this.directoryIdentifier;
    }

    public byte getPaddingField() {
        return this.paddingField;
    }

    public boolean isPaddingFieldPresent() {
        return this.paddingFieldPresent;
    }

    public long getVolumeIndex() {
        return this.volumeIndex;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }
}

