/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Array;
import ghidra.util.datastruct.DataTable;
import java.io.Serializable;

public class LongArray
implements Array,
Serializable {
    public static final long serialVersionUID = 1L;
    public static final int MIN_SIZE = 4;
    long[] longs = new long[4];
    int lastNonZeroIndex = -1;

    public void put(int index, long value) {
        if (value == 0L) {
            this.remove(index);
            return;
        }
        if (index >= this.longs.length) {
            this.adjustArray(Math.max(index + 1, this.longs.length * 2));
        }
        this.longs[index] = value;
        if (index > this.lastNonZeroIndex) {
            this.lastNonZeroIndex = index;
        }
    }

    @Override
    public void remove(int index) {
        if (index >= this.longs.length) {
            return;
        }
        this.longs[index] = 0L;
        if (index == this.lastNonZeroIndex) {
            this.lastNonZeroIndex = this.findLastNonZeroIndex();
        }
        if (this.lastNonZeroIndex < this.longs.length / 4) {
            this.adjustArray(this.lastNonZeroIndex * 2);
        }
    }

    private int findLastNonZeroIndex() {
        for (int i = this.lastNonZeroIndex; i >= 0; --i) {
            if (this.longs[i] == 0L) continue;
            return i;
        }
        return -1;
    }

    public long get(int index) {
        if (index < this.longs.length) {
            return this.longs[index];
        }
        return 0L;
    }

    private void adjustArray(int size) {
        if (size < 4) {
            size = 4;
        }
        long[] newlongs = new long[size];
        int len = Math.min(size, this.longs.length);
        System.arraycopy(this.longs, 0, newlongs, 0, len);
        this.longs = newlongs;
    }

    @Override
    public int getLastNonEmptyIndex() {
        return this.lastNonZeroIndex;
    }

    @Override
    public void copyDataTo(int index, DataTable table, int toIndex, int toCol) {
        table.putLong(toIndex, toCol, this.get(index));
    }
}

