/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import org.apache.commons.httpclient.Cookie;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.provider.http.HttpFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final HttpFileSystemConfigBuilder BUILDER = new HttpFileSystemConfigBuilder();
    private static final int DEFAULT_MAX_HOST_CONNECTIONS = 5;
    private static final int DEFAULT_MAX_CONNECTIONS = 50;
    private static final String OPTION_NAME_PREEMPTIVE_AUTHENTICATION = "preemptiveAuth";

    protected HttpFileSystemConfigBuilder(String prefix) {
        super(prefix);
    }

    private HttpFileSystemConfigBuilder() {
        super("http.");
    }

    public static HttpFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    public void setUrlCharset(FileSystemOptions opts, String chaset) {
        this.setParam(opts, "urlCharset", chaset);
    }

    public String getUrlCharset(FileSystemOptions opts) {
        return this.getString(opts, "urlCharset");
    }

    public void setProxyHost(FileSystemOptions opts, String proxyHost) {
        this.setParam(opts, "proxyHost", proxyHost);
    }

    public void setProxyPort(FileSystemOptions opts, int proxyPort) {
        this.setParam(opts, "proxyPort", new Integer(proxyPort));
    }

    public String getProxyHost(FileSystemOptions opts) {
        return this.getString(opts, "proxyHost");
    }

    public int getProxyPort(FileSystemOptions opts) {
        return this.getInteger(opts, "proxyPort", 0);
    }

    public void setProxyAuthenticator(FileSystemOptions opts, UserAuthenticator authenticator) {
        this.setParam(opts, "proxyAuthenticator", authenticator);
    }

    public UserAuthenticator getProxyAuthenticator(FileSystemOptions opts) {
        return (UserAuthenticator)this.getParam(opts, "proxyAuthenticator");
    }

    public void setCookies(FileSystemOptions opts, Cookie[] cookies) {
        this.setParam(opts, "cookies", cookies);
    }

    public Cookie[] getCookies(FileSystemOptions opts) {
        return (Cookie[])this.getParam(opts, "cookies");
    }

    public void setMaxTotalConnections(FileSystemOptions opts, int maxTotalConnections) {
        this.setParam(opts, "http.connection-manager.max-total", new Integer(maxTotalConnections));
    }

    public int getMaxTotalConnections(FileSystemOptions opts) {
        return this.getInteger(opts, "http.connection-manager.max-total", 50);
    }

    public void setMaxConnectionsPerHost(FileSystemOptions opts, int maxHostConnections) {
        this.setParam(opts, "http.connection-manager.max-per-host", new Integer(maxHostConnections));
    }

    public int getMaxConnectionsPerHost(FileSystemOptions opts) {
        return this.getInteger(opts, "http.connection-manager.max-per-host", 5);
    }

    public boolean isPreemptiveAuth(FileSystemOptions opts) {
        return this.getBoolean(opts, OPTION_NAME_PREEMPTIVE_AUTHENTICATION, Boolean.FALSE);
    }

    public void setPreemptiveAuth(FileSystemOptions opts, boolean preemptiveAuth) {
        this.setParam(opts, OPTION_NAME_PREEMPTIVE_AUTHENTICATION, preemptiveAuth);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return HttpFileSystem.class;
    }
}

