/*------------------------------------------------------+
 |	Definitions for WD100x hard disk controllers	|
 +------------------------------------------------------*/

/*
**  Port definitions:
*/
#define	WDP_BASE0  0x1f0	/* base address of primary controller */
#define	WDP_BASE1  0x170	/* base address of alternate controller */
#define	WDP_DAT	   0		/* offset to data reg (R/W) */
#define	WDP_ERR	   1		/* offset to error reg (R) */
#define	WDP_WPC	   1		/* offset to write precompensation reg (W) */
#define	WDP_SC	   2		/* offset to sector count reg (R/W) */
#define	WDP_SEC	   3		/* offset to sector address reg (R/W) */
#define	WDP_CL	   4		/* offset to cyl addr reg - low byte (R/W) */
#define	WDP_CH	   5		/* offset to cyl addr reg - high byte (R/W) */
#define	WDP_SDH	   6		/* offset to size/drive/head reg (R/W) */
#define	WDP_CSR	   7		/* offset to control/status reg (R/W) */
#define	WDP_ASR	   0x206	/* offset to alternate status reg (R) */
#define	WDP_DCR	   0x206	/* offset to device control reg (W) */
#define	WDP_DAR	   0x207	/* offset to device addr reg (R) */

/*
**  Controller command definitions:
*/
#define	WDC_HOM	   0x10		/* restore drv to trk 0 */
#define	WDC_SEK	   0x70		/* seek */
#define	WDC_RD	   0x20		/* read sectors */
#define	WDC_WRT	   0x30		/* write sectors */
#define	WDC_RVS	   0x40		/* read verify sectors */
#define	WDC_FMT	   0x50		/* format track */
#define	WDC_TST	   0x90		/* perform self test */
#define	WDC_IDP	   0x91		/* init drive parms */
#define	WDC_GDP	   0xec		/* get drive parameters */
#define	WDC_SDP	   0x91		/* set drive parameters */

/*
**  SDH register mask definitions:
*/
#define	WDM_ECC	   0x80		/* enable ECC */
#define	WDM_128	   0x60		/* 128 bytes/sector */
#define	WDM_256	   0x00		/* 256 bytes/sector */
#define	WDM_512	   0x20		/* 512 bytes/sector */
#define	WDM_1024   0x40		/* 1024 bytes/sector */

/*
**  Command/status register mask definitions:
*/
#define	WDM_HER	   0x01		/* hard error (R) */
#define	WDM_IDX	   0x02		/* index pulse status from drive (R) */
#define	WDM_CER	   0x04		/* corrected error (R) */
#define	WDM_DRQ	   0x08		/* data request (R) */
#define	WDM_SKC	   0x10		/* seek complete (R) */
#define	WDM_WTF	   0x20		/* write fault (R) */
#define	WDM_RDY	   0x40		/* ready (R) */
#define	WDM_BSY	   0x80		/* busy (R) */
#define	WDM_DRT	   0x01		/* disable retries (W) */

/*
**  Error register mask definitions:
*/
#define	WDM_DAE	   0x01		/* data address mark not found */
#define	WDM_T0E	   0x02		/* track 0 error */
#define	WDM_CAE	   0x04		/* aborted command */
#define	WDM_NIE	   0x10		/* ID not found */
#define	WDM_ICE	   0x20		/* CRC error - ID field */
#define	WDM_DCE	   0x40		/* CRC error - data field */
#define	WDM_BBE	   0x80		/* bad block detected */

#define	WDM_HS3    0x08		/* use reduced write current line for HS3 */
#define	WDM_RSTGO  0x04		/* start controller reset */
#define	WDM_RSTNO  0x00		/* end controller reset */
#define	WDM_IEN	   0x02		/* interrupt enable */

