/*
 * Copyright (c) 1997 Robert Nordier
 * All rights reserved.
 *
 * $Id: dosglob.c,v 1.1 1997/01/20 22:57:51 rnordier Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR(S) ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <dos.h>
#include <string.h>
#include "dospath.h"
#include "dosglob.h"

int
exparg(char *path, const char *pattern, int (*fn) (char *))
{
    struct _find_t ff;
    const char *meta;
    char *pos;
    size_t n;
    unsigned err;
    int rval, dot;

    pos = addslash(path, strchr(path, 0));
    if ((meta = metapath(pattern)) != NULL) {
	if ((n = (size_t) (meta - pattern)) != 0) {
	    strncpy(pos, pattern, n);
	    pos += n;
	}
	strcpy(pos, "*.*");
	dot = *meta == '.' || (*meta == '\\' && meta[1] == '.');
	pattern = metanext(meta);
	rval = 0;
	err = _dos_findfirst(path, _A_SUBDIR, &ff);
	while (!err) {
	    if ((*ff.name != '.' || dot) &&
		(!pattern || ff.attrib & _A_SUBDIR)) {
		_strlwr(strcpy(pos, ff.name));
		if (!strglob(pos, meta)) {
		    rval = pattern ? exparg(path, pattern, fn) : fn(path);
		    if (rval)
			break;
		}
	    }
	    err = _dos_findnext(&ff);
	}
    } else {
	strcpy(pos, pattern);
	rval = fn(path);
    }
    return rval;
}

char *
metapath(const char *path)
{
    const char *s, *t;

    if (*path && path[1] == ':')
	path += 2;
    if (*path == '/')
	path++;
    s = path;
    while ((s = strpbrk(s, "\\*?[/")) != NULL)
	switch (*s++) {
	case '\\':
	    if (*s)
		s++;
	    break;
	case '/':
	    path = s;
	    break;
	case '[':
	    t = s;
	    if (*t == '!')
		t++;
	    if (*t == ']')
		t++;
	    if (strchr(t, ']'))
		return (char *) path;
	    break;
	default:
	    return (char *) path;
	}
    return NULL;
}

char *
metanext(const char *path)
{
    while (*path && *path != '/')
	if (*path++ == '\\' && *path)
	    path++;
    return *path ? (char *) (path + 1) : NULL;
}

int
strglob(const char *str, const char *pat)
{
    const char *s;
    int c, not;

    while ((c = *pat++) != 0) {
	if (c == '/')
	    break;
	switch (c) {
	case '*':
	    for (s = strchr(str, 0); s > str; s--)
		if (!strglob(s, pat))
		    return 0;
	    continue;
	case '?':
	    if (!*str++)
		return 1;
	    continue;
	case '[':
	    not = *pat == '!';
	    s = pat + not;
	    if (*s == ']')
		s++;
	    if ((s = strchr(s, ']')) != NULL) {
		c = *str++;
		for (pat += not; pat < s; pat++)
		    if (pat + 2 < s && pat[1] == '-') {
			if (c >= *pat && c <= pat[2])
			    break;
			pat += 2;
		    } else if (c == *pat)
			break;
		if ((int) (pat == s) != not)
		    return 1;
		pat = s + 1;
		continue;
	    }
	    break;
	case '\\':
	    if (!*pat)
		continue;
	    c = *pat++;
	    /* falls through */
	default:
	    break;
	}
	if (*str++ != c)
	    return 1;
    }
    return *str != 0;
}
